<?php
/**
* 2007-2022 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2024 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
if (!defined('_PS_VERSION_')) {
    exit;
}

class Ecpatch extends Module
{
    public function __construct()
    {
        $this->name = 'ecpatch';
        $this->tab = 'administration';
        $this->version = '1.0.0';
        $this->author = 'Ether Creation';
        $this->need_instance = 0;
        $this->bootstrap = true;
        
        parent::__construct();
        
        $this->displayName = $this->l('EC Patch CVE-2025-51586');
        $this->description = $this->l('Vérifie et corrige la faille CVE-2025-51586');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        return parent::install();
    }

    public function uninstall()
    {
        return parent::uninstall();
    }

    public function patchAdminLoginController()
    {
        try {
            $file_path = _PS_ADMIN_CONTROLLER_DIR_ . 'AdminLoginController.php';
            
            if (!file_exists($file_path)) {
                return array('error' => 'Le fichier AdminLoginController.php n\'existe pas');
            }

            $content = file_get_contents($file_path);
            if ($content === false) {
                return array('error' => 'Impossible de lire le fichier');
            }

            if (strpos($content, '// CVE-2025-51586 PATCHED') !== false) {
                return array('status' => 'already_patched');
            }

            $backup_path = $file_path . '.backup.' . date('Ymd_His');
            if (!copy($file_path, $backup_path)) {
                return array('error' => 'Impossible de créer une sauvegarde');
            }

            $pattern = '/\/\/\s*For\s+reset\s+password\s+feature.*?if\s*\(\s*\$reset_token\s*=\s*Tools::getValue\(\'reset_token\'\)\)\s*\{[^}]*\$this->context->smarty->assign\(\'reset_token\',\s*\$reset_token\);[^}]*\}[^}]*if\s*\(\s*\$id_employee\s*=\s*Tools::getValue\(\'id_employee\'\)\)[^}]*\{[^}]*\$this->context->smarty->assign\(\'id_employee\',\s*\$id_employee\);[^}]*new\s+Employee\([^}]*\$this->context->smarty->assign\(\'reset_email\'[^}]*\}/s';

            $replacement = '// For reset password feature
                // CVE-2025-51586 PATCHED by Ether Creation
                $reset_token = Tools::getValue(\'reset_token\');
                $id_employee = Tools::getValue(\'id_employee\');
                if ($reset_token !== false && $id_employee !== false) {
                    $employee = new Employee((int) $id_employee);
                    if (Validate::isLoadedObject($employee)) {
                        // Vérification du token de réinitialisation
                        if (method_exists($employee, \'getValidResetPasswordToken\')) {
                            $valid_reset_token = $employee->getValidResetPasswordToken();
                            if ($valid_reset_token !== false && hash_equals($valid_reset_token, (string) $reset_token)) {
                                $this->context->smarty->assign(\'reset_token\', $reset_token);
                                $this->context->smarty->assign(\'id_employee\', $id_employee);
                                $this->context->smarty->assign(\'reset_email\', $employee->email);
                            }
                        } else {
                            // Fallback pour versions antérieures sans getValidResetPasswordToken
                            $this->context->smarty->assign(\'reset_token\', $reset_token);
                            $this->context->smarty->assign(\'id_employee\', $id_employee);
                            $this->context->smarty->assign(\'reset_email\', $employee->email);
                        }
                    }';

            $new_content = preg_replace($pattern, $replacement, $content);
            
            if ($new_content === null) {
                return array('error' => 'Erreur dans l\'expression régulière');
            }
            
            if ($new_content === $content) {
                return $this->patchWithSimpleSearch($content, $file_path, $backup_path);
            }

            if (file_put_contents($file_path, $new_content) === false) {
                return array('error' => 'Impossible d\'écrire le fichier modifié');
            }

            return array('success' => true, 'backup' => basename($backup_path));
            
        } catch (Exception $e) {
            return array('error' => 'Erreur: ' . $e->getMessage());
        }
    }

    private function patchWithSimpleSearch($content, $file_path, $backup_path)
    {
        $lines = explode("\n", $content);
        $patched_lines = array();
        $in_vulnerable_section = false;
        $section_buffer = array();
        
        for ($i = 0; $i < count($lines); $i++) {
            $line = $lines[$i];
            
            if (strpos($line, '// For reset password feature') !== false) {
                $in_vulnerable_section = true;
                $section_buffer = array($line);
                continue;
            }
            
            if ($in_vulnerable_section) {
                $section_buffer[] = $line;
                
                if (strpos($line, 'reset_email') !== false && strpos($line, 'assign') !== false) {
                    $brace_count = 0;
                    for ($j = $i + 1; $j < count($lines) && $j < $i + 5; $j++) {
                        $section_buffer[] = $lines[$j];
                        if (strpos($lines[$j], '}') !== false) {
                            $brace_count++;
                            if ($brace_count >= 2) {
                                $i = $j; 
                                break;
                            }
                        }
                    }
                    
                    $patched_lines[] = '// For reset password feature';
                    $patched_lines[] = '// CVE-2025-51586 PATCHED by Ether Creation';
                    $patched_lines[] = '$reset_token = Tools::getValue(\'reset_token\');';
                    $patched_lines[] = '$id_employee = Tools::getValue(\'id_employee\');';
                    $patched_lines[] = 'if ($reset_token !== false && $id_employee !== false) {';
                    $patched_lines[] = '    $employee = new Employee((int) $id_employee);';
                    $patched_lines[] = '    if (Validate::isLoadedObject($employee)) {';
                    $patched_lines[] = '        if (method_exists($employee, \'getValidResetPasswordToken\')) {';
                    $patched_lines[] = '            $valid_reset_token = $employee->getValidResetPasswordToken();';
                    $patched_lines[] = '            if ($valid_reset_token !== false && hash_equals($valid_reset_token, (string) $reset_token)) {';
                    $patched_lines[] = '                $this->context->smarty->assign(\'reset_token\', $reset_token);';
                    $patched_lines[] = '                $this->context->smarty->assign(\'id_employee\', $id_employee);';
                    $patched_lines[] = '                $this->context->smarty->assign(\'reset_email\', $employee->email);';
                    $patched_lines[] = '            }';
                    $patched_lines[] = '        } else {';
                    $patched_lines[] = '            $this->context->smarty->assign(\'reset_token\', $reset_token);';
                    $patched_lines[] = '            $this->context->smarty->assign(\'id_employee\', $id_employee);';
                    $patched_lines[] = '            $this->context->smarty->assign(\'reset_email\', $employee->email);';
                    $patched_lines[] = '        }';
                    $patched_lines[] = '    }';
                    
                    $in_vulnerable_section = false;
                    $section_buffer = array();
                    continue;
                }
            } else {
                $patched_lines[] = $line;
            }
        }
        
        if ($in_vulnerable_section) {
            return array('error' => 'Section vulnérable détectée mais remplacement incomplet');
        }
        
        $new_content = implode("\n", $patched_lines);
        
        if (file_put_contents($file_path, $new_content) === false) {
            return array('error' => 'Impossible d\'écrire le fichier modifié');
        }
        
        return array('success' => true, 'backup' => basename($backup_path));
    }

    public function getContent()
    {
        $html = '';
        
        if (Tools::isSubmit('apply_patch_btn')) {
            $result = $this->patchAdminLoginController();
            
            if (isset($result['success'])) {
                $html .= $this->displayConfirmation(
                    'Patch appliqué avec succès !<br>' .
                    'Sauvegarde créée: ' . $result['backup']
                );
            } elseif (isset($result['status']) && $result['status'] == 'already_patched') {
                $html .= $this->displayInformation('Le fichier est déjà patché.');
            } else {
                $html .= $this->displayError(isset($result['error']) ? $result['error'] : 'Erreur inconnue');
            }
        }

        $file_path = _PS_ADMIN_CONTROLLER_DIR_ . 'AdminLoginController.php';
        $is_patched = false;
        $file_exists = false;
        
        if (file_exists($file_path)) {
            $file_exists = true;
            $content = file_get_contents($file_path);
            $is_patched = (strpos($content, '// CVE-2025-51586 PATCHED') !== false);
        }

        $html .= '<div class="panel">
            <div class="panel-heading">
                <i class="icon-shield"></i> EC Patch CVE-2025-51586
            </div>
            <div class="panel-body">';

        if (!$file_exists) {
            $html .= '<div class="alert alert-danger">
                <strong>Fichier non trouvé :</strong> AdminLoginController.php
            </div>';
        } elseif ($is_patched) {
            $html .= '<div class="alert alert-success">
                <strong>Statut :</strong> Votre boutique est protégée contre CVE-2025-51586
            </div>';
        } else {
            $html .= '<div class="alert alert-warning">
                <strong>Attention :</strong> Votre boutique est vulnérable à CVE-2025-51586
            </div>';
        }

        $html .= '<h4>À propos de cette vulnérabilité</h4>
            <p>CVE-2025-51586 permet l\'énumération des adresses email des employés via l\'URL back-office.</p>
            
            <ul>
                <li><strong>Gravité :</strong> Basse (3.7/10)</li>
                <li><strong>Versions concernées :</strong> PrestaShop 1.7 à 8.2.2</li>
                <li><strong>Solution :</strong> Mise à jour vers 8.2.3 ou application de ce patch</li>
            </ul>';

        if ($file_exists && !$is_patched) {
            $html .= '<form method="post" style="margin: 20px 0;">
                <button type="submit" name="apply_patch_btn" class="btn btn-primary btn-lg">
                    <i class="icon-shield"></i> Appliquer le patch de sécurité
                </button>
            </form>';
        }

        $html .= '<hr>
            <p><small>Développé par <strong><a href="https://www.ethercreation.com" target="_blank">Ether Création</a></strong> - Agence Web & E-commerce</small></p>
            
            <!-- Bandeau promotionnel modules -->
            <div style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border: 2px solid #dee2e6; border-radius: 12px; padding: 25px; margin: 20px 0; color: #495057; box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                <div style="text-align: center; margin-bottom: 20px;">
                    <img src="https://img.icons8.com/fluency/48/000000/module.png" alt="Modules" style="width: 40px; height: 40px; margin-bottom: 10px;">
                    <h4 style="color: #495057; margin: 0; font-weight: bold;">
                        🌟 Nos Modules Premium pour PrestaShop
                    </h4>
                </div>
                
                <div class="row" style="display: flex; flex-wrap: wrap; gap: 15px;">
                    <!-- Module SEO -->
                    <div style="flex: 1; min-width: 250px; background: #fff; border: 1px solid #dee2e6; border-radius: 8px; padding: 18px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); transition: transform 0.2s;">
                        <div style="text-align: center; margin-bottom: 12px;">
                            <img src="https://assets.prestashop3.com/addons/pico/49487.jpg" alt="SEO" style="width: 57px; height: 57px;">
                        </div>
                        <h5 style="color: #28a745; margin-bottom: 10px; text-align: center; font-weight: bold;">
                            Presta SEO Complet
                        </h5>
                        <p style="font-size: 13px; margin-bottom: 15px; color: #6c757d; text-align: center; line-height: 1.4;">
                            Audit SEO avancé, méta-données automatiques, sitemap XML, données structurées, optimisation complète
                        </p>
                        <div style="text-align: center;">
                            <a href="https://addons.prestashop.com/fr/seo-referencement-naturel/49487-presta-seo-complet-outil-audit-avancee.html" target="_blank" 
                               style="background: #28a745; color: white; padding: 8px 16px; border-radius: 5px; text-decoration: none; font-size: 12px; font-weight: bold; display: inline-block; transition: background 0.2s;">
                                📈 Optimisez mon SEO
                            </a>
                        </div>
                    </div>
                    
                    <!-- Module Cloudflare -->
                    <div style="flex: 1; min-width: 250px; background: #fff; border: 1px solid #dee2e6; border-radius: 8px; padding: 18px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); transition: transform 0.2s;">
                        <div style="text-align: center; margin-bottom: 12px;">
                            <img src="https://assets.prestashop3.com/addons/pico/95889.jpg" alt="Cloudflare" style="width: 57px; height: 57px;">
                        </div>
                        <h5 style="color: #ff6b35; margin-bottom: 10px; text-align: center; font-weight: bold;">
                            Cloudflare Turnstile
                        </h5>
                        <p style="font-size: 13px; margin-bottom: 15px; color: #6c757d; text-align: center; line-height: 1.4;">
                            Sécurité invisible sans captcha, protection Cloudflare intégrée, blocage bots automatique
                        </p>
                        <div style="text-align: center;">
                            <a href="https://addons.prestashop.com/fr/securite-access/95889-cloudflare-turnstile-securite-invisible-sans-captcha.html" target="_blank" 
                               style="background: #ff6b35; color: white; padding: 8px 16px; border-radius: 5px; text-decoration: none; font-size: 12px; font-weight: bold; display: inline-block; transition: background 0.2s;">
                                🛡️ Sécuriser mes formulaires
                            </a>
                        </div>
                    </div>
                    
                    <!-- Module Sécurité 2FA -->
                    <div style="flex: 1; min-width: 250px; background: #fff; border: 1px solid #dee2e6; border-radius: 8px; padding: 18px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); transition: transform 0.2s;">
                        <div style="text-align: center; margin-bottom: 12px;">
                            <img src="https://assets.prestashop3.com/addons/p/1673912/1673912-pbig.jpg" alt="2FA" style="width: 57px; height: 57px;">
                        </div>
                        <h5 style="color: #dc3545; margin-bottom: 10px; text-align: center; font-weight: bold;">
                            Google Auth 2FA
                        </h5>
                        <p style="font-size: 13px; margin-bottom: 15px; color: #6c757d; text-align: center; line-height: 1.4;">
                            Authentification 2 facteurs Google, sécurisation back-office, logs connexions détaillés
                        </p>
                        <div style="text-align: center;">
                            <a href="https://addons.prestashop.com/fr/connexion-inscription-reseaux-sociaux/96021-google-authentification-2fa-backoffice-prestashop.html" target="_blank" 
                               style="background: #dc3545; color: white; padding: 8px 16px; border-radius: 5px; text-decoration: none; font-size: 12px; font-weight: bold; display: inline-block; transition: background 0.2s;">
                                🔒 Protéger le BO
                            </a>
                        </div>
                    </div>
                </div>
                
                <div style="text-align: center; margin-top: 20px; padding-top: 15px; border-top: 2px solid #e9ecef;">
                    <p style="margin: 0; font-size: 13px; color: #6c757d; font-weight: 500;">
                        ⭐ <strong>Support technique inclus</strong> • 🆓 <strong>Installation gratuite</strong> • 🔄 <strong>Mises à jour régulières</strong>
                    </p>
                </div>
            </div>
            </div>
        </div>';

        return $html;
    }
}